/*
 * Decompiled with CFR 0.152.
 */
package eu.openanalytics.shinyproxy;

import jakarta.servlet.http.HttpServletRequest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * Exception performing whole class analysis ignored.
 */
public class AppRequestInfo {
    private static final Pattern APP_INSTANCE_PATTERN = Pattern.compile(".*?/(app_i|app_direct_i)/([^/]*)/([^/]*)(/?.*)");
    private static final Pattern APP_PATTERN = Pattern.compile(".*?/(app|app_direct)/([^/]*)(/?.*)");
    public static final Pattern INSTANCE_NAME_PATTERN = Pattern.compile("^[a-zA-Z0-9_.-]*$");
    private final String appName;
    private final String appInstance;
    private final String subPath;
    private final String appPath;

    public AppRequestInfo(String appName, String appInstance, String appPath, String subPath) {
        this.appName = appName;
        this.appInstance = appInstance;
        this.appPath = appPath;
        this.subPath = subPath;
    }

    public static AppRequestInfo fromRequestOrNull(HttpServletRequest request) {
        return AppRequestInfo.fromURI((String)request.getRequestURI());
    }

    public static AppRequestInfo fromURI(String uri) {
        Matcher appMatcher = APP_PATTERN.matcher(uri);
        Matcher appInstanceMatcher = APP_INSTANCE_PATTERN.matcher(uri);
        if (appInstanceMatcher.matches()) {
            String appPath;
            String appName = appInstanceMatcher.group(2);
            if (appName == null || appName.trim().isEmpty()) {
                return null;
            }
            String appInstance = appInstanceMatcher.group(3);
            if (appInstance == null || appInstance.trim().isEmpty()) {
                return null;
            }
            if (appInstance.length() > 64 || !INSTANCE_NAME_PATTERN.matcher(appInstance).matches()) {
                return null;
            }
            String subPath = appInstanceMatcher.group(4);
            if (subPath == null || subPath.trim().isEmpty()) {
                subPath = null;
                appPath = uri;
            } else {
                subPath = subPath.trim().substring(1);
                appPath = uri.substring(0, uri.length() - subPath.length());
            }
            return new AppRequestInfo(appName, appInstance, appPath, subPath);
        }
        if (appMatcher.matches()) {
            String appPath;
            String appName = appMatcher.group(2);
            if (appName == null || appName.trim().isEmpty()) {
                return null;
            }
            String appInstance = "_";
            String subPath = appMatcher.group(3);
            if (subPath == null || subPath.trim().isEmpty()) {
                subPath = null;
                appPath = uri;
            } else {
                subPath = subPath.trim().substring(1);
                appPath = uri.substring(0, uri.length() - subPath.length());
            }
            return new AppRequestInfo(appName, appInstance, appPath, subPath);
        }
        return null;
    }

    public String getAppInstance() {
        return this.appInstance;
    }

    public String getAppName() {
        return this.appName;
    }

    public String getSubPath() {
        return this.subPath;
    }

    public String getAppPath() {
        return this.appPath;
    }
}

