/*
 * Decompiled with CFR 0.152.
 */
package eu.openanalytics.shinyproxy;

import eu.openanalytics.shinyproxy.AuthenticationRequiredFilter;
import eu.openanalytics.shinyproxy.controllers.dto.ShinyProxyApiResponse;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.client.ClientAuthorizationRequiredException;
import org.springframework.security.web.util.ThrowableAnalyzer;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.OrRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.web.filter.GenericFilterBean;

public class AuthenticationRequiredFilter
extends GenericFilterBean {
    private static final RequestMatcher REQUEST_MATCHER = new OrRequestMatcher(new RequestMatcher[]{new AntPathRequestMatcher("/app_proxy/**"), new AntPathRequestMatcher("/heartbeat/*"), new AntPathRequestMatcher("/api/**"), new AntPathRequestMatcher("/admin/data"), new AntPathRequestMatcher("/issue")});
    private final ThrowableAnalyzer throwableAnalyzer = new DefaultThrowableAnalyzer();

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        try {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            if (REQUEST_MATCHER.matches(request) && this.isAuthException(ex)) {
                if (response.isCommitted()) {
                    throw new ServletException("Unable to handle the Spring Security Exception because the response is already committed.", (Throwable)ex);
                }
                SecurityContextHolder.getContext().setAuthentication(null);
                ShinyProxyApiResponse.authenticationRequired((HttpServletResponse)response);
                return;
            }
            throw ex;
        }
    }

    private boolean isAuthException(Exception ex) {
        Throwable[] causeChain = this.throwableAnalyzer.determineCauseChain((Throwable)ex);
        Throwable type = this.throwableAnalyzer.getFirstThrowableOfType(AuthenticationException.class, causeChain);
        if (type != null) {
            return true;
        }
        type = this.throwableAnalyzer.getFirstThrowableOfType(ClientAuthorizationRequiredException.class, causeChain);
        if (type != null) {
            return true;
        }
        type = this.throwableAnalyzer.getFirstThrowableOfType(AccessDeniedException.class, causeChain);
        return type != null;
    }
}

