/*
 * Decompiled with CFR 0.152.
 */
package eu.openanalytics.shinyproxy;

import eu.openanalytics.containerproxy.backend.dispatcher.ProxyDispatcherService;
import eu.openanalytics.containerproxy.backend.strategy.IProxyTestStrategy;
import eu.openanalytics.containerproxy.model.runtime.Proxy;
import eu.openanalytics.containerproxy.service.StructuredLogger;
import eu.openanalytics.containerproxy.util.Retrying;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Primary;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
@Primary
public class ShinyProxyTestStrategy
implements IProxyTestStrategy {
    private final StructuredLogger slog = StructuredLogger.create(this.getClass());
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final List<Integer> ALLOWED_RESPONSE_CODES = Arrays.asList(200, 301, 302, 303, 307, 308);
    @Inject
    private Environment environment;
    @Inject
    private ProxyDispatcherService proxyDispatcherService;
    private int totalWaitMs;
    private int requestTimeout;

    @PostConstruct
    public void init() {
        this.totalWaitMs = Integer.parseInt(this.environment.getProperty("proxy.container-wait-time", "20000"));
        this.requestTimeout = Integer.parseInt(this.environment.getProperty("proxy.container-wait-timeout", "5000"));
    }

    public boolean testProxy(Proxy proxy) {
        if (!Objects.equals(proxy.getTargetId(), proxy.getId())) {
            return true;
        }
        if (proxy.getTargets().isEmpty()) {
            return false;
        }
        URI targetURI = (URI)proxy.getTargets().get("");
        return Retrying.retry((currentAttempt, maxAttempts) -> {
            if (proxy.getStatus().isUnavailable()) {
                return new Retrying.Result(false, false);
            }
            if (currentAttempt > 5 && !this.proxyDispatcherService.getDispatcher(proxy.getSpecId()).isProxyHealthy(proxy)) {
                return new Retrying.Result(false, false);
            }
            URL testURL = new URI(targetURI.toString() + "/").toURL();
            HttpURLConnection connection = (HttpURLConnection)testURL.openConnection();
            if (currentAttempt <= 5) {
                connection.setConnectTimeout(200);
                connection.setReadTimeout(200);
            } else {
                connection.setConnectTimeout(this.requestTimeout);
                connection.setReadTimeout(this.requestTimeout);
            }
            connection.setInstanceFollowRedirects(false);
            int responseCode = connection.getResponseCode();
            if (ALLOWED_RESPONSE_CODES.contains(responseCode)) {
                return Retrying.SUCCESS;
            }
            if (currentAttempt > 10) {
                this.logger.warn("Received invalid status code '{}' while checking reachability of application at {}, expected one of '{}'", new Object[]{responseCode, targetURI, ALLOWED_RESPONSE_CODES});
            }
            return Retrying.FAILURE;
        }, (int)this.totalWaitMs, (String)("Checking application reachable at " + String.valueOf(targetURI)), (int)10, (Proxy)proxy, (StructuredLogger)this.slog);
    }
}

