/*
 * Decompiled with CFR 0.152.
 */
package eu.openanalytics.shinyproxy;

import eu.openanalytics.containerproxy.auth.IAuthenticationBackend;
import eu.openanalytics.containerproxy.security.ICustomSecurityConfig;
import eu.openanalytics.containerproxy.service.ProxyAccessControlService;
import eu.openanalytics.containerproxy.service.UserService;
import eu.openanalytics.shinyproxy.AuthenticationRequiredFilter;
import jakarta.servlet.Filter;
import javax.inject.Inject;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.authorization.AuthorizationDecision;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.RedirectStrategy;
import org.springframework.security.web.access.ExceptionTranslationFilter;
import org.springframework.security.web.authentication.SavedRequestAwareAuthenticationSuccessHandler;
import org.springframework.security.web.servlet.util.matcher.MvcRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.handler.HandlerMappingIntrospector;

@Component
public class UISecurityConfig
implements ICustomSecurityConfig {
    @Inject
    private IAuthenticationBackend auth;
    @Inject
    private UserService userService;
    @Inject
    @Lazy
    private SavedRequestAwareAuthenticationSuccessHandler savedRequestAwareAuthenticationSuccessHandler;
    @Inject
    private ProxyAccessControlService proxyAccessControlService;
    @Inject
    private HandlerMappingIntrospector handlerMappingIntrospector;

    public void apply(HttpSecurity http) throws Exception {
        http.authorizeHttpRequests(authz -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authz.requestMatchers(new RequestMatcher[]{new MvcRequestMatcher(this.handlerMappingIntrospector, "/app/{specId}/**"), new MvcRequestMatcher(this.handlerMappingIntrospector, "/app_i/{specId}/**"), new MvcRequestMatcher(this.handlerMappingIntrospector, "/app_direct/{specId}/**"), new MvcRequestMatcher(this.handlerMappingIntrospector, "/app_direct_i/{specId}/**")})).access((authentication, context) -> new AuthorizationDecision(this.proxyAccessControlService.canAccessOrHasExistingProxy((Authentication)authentication.get(), context))));
        if (this.auth.hasAuthorization()) {
            http.addFilterAfter((Filter)new AuthenticationRequiredFilter(), ExceptionTranslationFilter.class);
            this.savedRequestAwareAuthenticationSuccessHandler.setRedirectStrategy((RedirectStrategy)new /* Unavailable Anonymous Inner Class!! */);
        }
        http.authorizeHttpRequests(authz -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authz.requestMatchers(new RequestMatcher[]{new MvcRequestMatcher(this.handlerMappingIntrospector, "/admin"), new MvcRequestMatcher(this.handlerMappingIntrospector, "/admin/**"), new MvcRequestMatcher(this.handlerMappingIntrospector, "/grafana/**")})).access((authentication, context) -> new AuthorizationDecision(this.userService.isAdmin((Authentication)authentication.get()))));
    }
}

