/*
 * Decompiled with CFR 0.152.
 */
package eu.openanalytics.shinyproxy.controllers;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import eu.openanalytics.containerproxy.auth.IAuthenticationBackend;
import eu.openanalytics.containerproxy.backend.IContainerBackend;
import eu.openanalytics.containerproxy.model.runtime.Proxy;
import eu.openanalytics.containerproxy.model.spec.ProxySpec;
import eu.openanalytics.containerproxy.service.IdentifierService;
import eu.openanalytics.containerproxy.service.ProxyService;
import eu.openanalytics.containerproxy.service.UserAndTargetIdProxyIndex;
import eu.openanalytics.containerproxy.service.UserService;
import eu.openanalytics.containerproxy.service.heartbeat.HeartbeatService;
import eu.openanalytics.containerproxy.spec.expression.SpecExpressionContext;
import eu.openanalytics.containerproxy.spec.expression.SpecExpressionResolver;
import eu.openanalytics.containerproxy.util.ContextPathHelper;
import eu.openanalytics.containerproxy.util.EnvironmentUtils;
import eu.openanalytics.shinyproxy.AppRequestInfo;
import eu.openanalytics.shinyproxy.ShinyProxySpecProvider;
import eu.openanalytics.shinyproxy.Thymeleaf;
import eu.openanalytics.shinyproxy.UserAndAppNameAndInstanceNameProxyIndex;
import eu.openanalytics.shinyproxy.controllers.BaseController;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLConnection;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.core.env.Environment;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.ui.ModelMap;
import org.springframework.util.StreamUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class BaseController {
    private static final Logger logger = LogManager.getLogger(BaseController.class);
    private static final Cache<String, Optional<LogoInfo>> logoInfoCache = Caffeine.newBuilder().build();
    protected String applicationName;
    protected String title;
    private Boolean titleContainsExpression;
    private Boolean logoContainsExpression;
    protected String logo;
    private final Cache<String, Optional<String>> logoCache = Caffeine.newBuilder().build();
    protected long heartbeatRate;
    protected boolean defaultShowNavbar;
    protected String defaultSupportAddress;
    protected String defaultLogo;
    protected String defaultLogoWidth;
    protected String defaultLogoHeight;
    protected String defaultLogoStyle;
    protected String defaultLogoClasses;
    protected String bodyClasses;
    @Inject
    protected ShinyProxySpecProvider shinyProxySpecProvider;
    @Inject
    protected ProxyService proxyService;
    @Inject
    protected UserService userService;
    @Inject
    protected Environment environment;
    @Inject
    protected IAuthenticationBackend authenticationBackend;
    @Inject
    protected HeartbeatService heartbeatService;
    @Inject
    protected IdentifierService identifierService;
    @Inject
    protected ContextPathHelper contextPathHelper;
    @Inject
    protected UserAndAppNameAndInstanceNameProxyIndex userAndAppNameAndInstanceNameProxyIndex;
    @Inject
    protected UserAndTargetIdProxyIndex userAndTargetIdProxyIndex;
    protected Boolean allowTransferApp;
    @Inject
    private IContainerBackend backend;
    @Inject
    private Thymeleaf thymeleaf;
    @Inject
    protected SpecExpressionResolver expressionResolver;

    @PostConstruct
    public void baseInit() {
        this.defaultLogo = this.resolveImageURI(this.environment.getProperty("proxy.default-app-logo-url")).orElse(null);
        this.defaultLogoWidth = this.environment.getProperty("proxy.default-app-logo-width");
        this.defaultLogoHeight = this.environment.getProperty("proxy.default-app-logo-height");
        this.defaultLogoStyle = this.environment.getProperty("proxy.default-app-logo-style");
        this.defaultLogoClasses = this.environment.getProperty("proxy.default-app-logo-classes");
        this.logo = this.environment.getProperty("proxy.logo-url", "");
        this.logoContainsExpression = this.logo.contains("#{");
        this.applicationName = this.environment.getProperty("spring.application.name");
        this.title = this.environment.getProperty("proxy.title", "ShinyProxy");
        this.titleContainsExpression = this.title.contains("#{");
        this.heartbeatRate = this.heartbeatService.getHeartbeatRate();
        this.defaultShowNavbar = !Boolean.parseBoolean(this.environment.getProperty("proxy.hide-navbar"));
        this.defaultSupportAddress = this.environment.getProperty("proxy.support.mail-to-address");
        this.allowTransferApp = (Boolean)this.environment.getProperty("proxy.allow-transfer-app", Boolean.class, (Object)false);
        List bodyClassesList = EnvironmentUtils.readList((Environment)this.environment, (String)"proxy.body-classes");
        this.bodyClasses = bodyClassesList != null && !bodyClassesList.isEmpty() ? String.join((CharSequence)" ", bodyClassesList) : "";
    }

    protected Proxy findUserProxy(AppRequestInfo appRequestInfo) {
        return this.findUserProxy(appRequestInfo.getAppName(), appRequestInfo.getAppInstance());
    }

    protected Proxy findUserProxy(String appname, String appInstance) {
        return this.userAndAppNameAndInstanceNameProxyIndex.getProxy(this.userService.getCurrentUserId(), appname, appInstance);
    }

    protected void prepareMap(ModelMap map, HttpServletRequest request) {
        this.prepareMap(map, request, null, null);
    }

    protected void prepareMap(ModelMap map, HttpServletRequest request, ProxySpec proxySpec, Proxy proxy) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        String serverName = request.getServerName();
        this.addTitleAndLogo(authentication, proxySpec, proxy, serverName, map);
        map.put((Object)"application_name", (Object)this.applicationName);
        String hideNavBarParam = request.getParameter("sp_hide_navbar");
        if (Objects.equals(hideNavBarParam, "true")) {
            map.put((Object)"showNavbar", (Object)false);
        } else {
            map.put((Object)"showNavbar", (Object)this.defaultShowNavbar);
        }
        map.put((Object)"bootstrapCss", (Object)"/css/bootstrap.css");
        map.put((Object)"bootstrapJs", (Object)"/js/bootstrap.js");
        map.put((Object)"jqueryJs", (Object)"/webjars/jquery/3.7.1/jquery.min.js");
        map.put((Object)"handlebars", (Object)"/webjars/handlebars/4.7.7/handlebars.runtime.min.js");
        boolean isLoggedIn = authentication != null && !(authentication instanceof AnonymousAuthenticationToken) && authentication.isAuthenticated();
        map.put((Object)"isLoggedIn", (Object)isLoggedIn);
        map.put((Object)"isAdmin", (Object)this.userService.isAdmin(authentication));
        map.put((Object)"isSupportEnabled", (Object)(isLoggedIn && this.defaultSupportAddress != null ? 1 : 0));
        map.put((Object)"logoutUrl", (Object)this.authenticationBackend.getLogoutURL());
        map.put((Object)"page", (Object)"");
        map.put((Object)"maxInstances", (Object)0);
        map.put((Object)"contextPath", (Object)this.contextPathHelper.withEndingSlash());
        map.put((Object)"resourcePrefix", (Object)("/" + this.identifierService.instanceId));
        map.put((Object)"appMaxInstances", (Object)this.shinyProxySpecProvider.getMaxInstances());
        map.put((Object)"pauseSupported", (Object)this.backend.supportsPause());
        map.put((Object)"spInstance", (Object)this.identifierService.instanceId);
        map.put((Object)"allowTransferApp", (Object)this.allowTransferApp);
        map.put((Object)"notificationMessage", (Object)this.environment.getProperty("proxy.notification-message"));
        map.put((Object)"bodyClasses", (Object)this.bodyClasses);
        List apps = this.proxyService.getUserSpecs();
        Thymeleaf.GroupedProxySpecs groupedApps = this.thymeleaf.groupApps(apps);
        map.put((Object)"apps", (Object)apps);
        map.put((Object)"appIds", (Object)groupedApps.getIds());
        map.put((Object)"templateGroups", (Object)groupedApps.getTemplateGroups());
        map.put((Object)"groupedApps", (Object)groupedApps.getGroupedApps());
        map.put((Object)"ungroupedApps", (Object)groupedApps.getUngroupedApps());
        HashMap<ProxySpec, LogoInfo> appLogos = new HashMap<ProxySpec, LogoInfo>();
        for (ProxySpec app : this.shinyProxySpecProvider.getSpecs()) {
            appLogos.put(app, this.getAppLogoInfo(app));
        }
        map.put((Object)"appLogos", appLogos);
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.currentRequestAttributes();
        HttpServletRequest httpServletRequest = servletRequestAttributes.getRequest();
        HttpServletResponse httpServletResponse = servletRequestAttributes.getResponse();
        map.put((Object)"request", (Object)httpServletRequest);
        map.put((Object)"response", (Object)httpServletResponse);
    }

    protected String getDefaultSupportAddress() {
        return this.environment.getProperty("proxy.support.mail-to-address");
    }

    protected LogoInfo getAppLogoInfo(ProxySpec proxySpec) {
        return ((Optional)logoInfoCache.get((Object)proxySpec.getId(), specId -> {
            String src = this.resolveImageURI(proxySpec.getLogoURL()).orElse(this.defaultLogo);
            if (src == null) {
                return Optional.empty();
            }
            return Optional.of(LogoInfo.builder().src(src).width((String)this.coalesce((Object)proxySpec.getLogoWidth(), (Object)this.defaultLogoWidth)).height((String)this.coalesce((Object)proxySpec.getLogoHeight(), (Object)this.defaultLogoHeight)).style((String)this.coalesce((Object)proxySpec.getLogoStyle(), (Object)this.defaultLogoStyle)).classes((String)this.coalesce((Object)proxySpec.getLogoClasses(), (Object)this.defaultLogoClasses)).build());
        })).orElse(null);
    }

    protected Optional<String> resolveImageURI(String resourceURI) {
        if (resourceURI == null || resourceURI.isBlank()) {
            return Optional.empty();
        }
        if (resourceURI.toLowerCase().startsWith("file://")) {
            Optional<String> optional;
            block11: {
                String mimetype = URLConnection.guessContentTypeFromName(resourceURI);
                if (mimetype == null) {
                    logger.warn("Cannot determine mimetype for resource: {}", (Object)resourceURI);
                    return Optional.empty();
                }
                InputStream input = new URI(resourceURI).toURL().openConnection().getInputStream();
                try {
                    byte[] data = StreamUtils.copyToByteArray((InputStream)input);
                    String encoded = Base64.getEncoder().encodeToString(data);
                    optional = Optional.of(String.format("data:%s;base64,%s", mimetype, encoded));
                    if (input == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (input != null) {
                            try {
                                input.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException | URISyntaxException e) {
                        logger.warn("Failed to convert file URI to data URI: " + resourceURI, (Throwable)e);
                        return Optional.empty();
                    }
                }
                input.close();
            }
            return optional;
        }
        return Optional.of(resourceURI);
    }

    protected boolean validateMaxInstances(ProxySpec spec) {
        Integer maxInstances = this.shinyProxySpecProvider.getMaxInstancesForSpec(spec);
        if (maxInstances == -1) {
            return true;
        }
        long currentAmountOfInstances = this.proxyService.getUserProxiesBySpecId(spec.getId()).count();
        return currentAmountOfInstances < (long)maxInstances.intValue();
    }

    private <T> T coalesce(T first, T second) {
        return first != null ? first : second;
    }

    private void addTitleAndLogo(Authentication user, ProxySpec proxySpec, Proxy proxy, String serverName, ModelMap map) {
        if (!this.titleContainsExpression.booleanValue() && !this.logoContainsExpression.booleanValue()) {
            map.put((Object)"title", (Object)this.title);
            map.put((Object)"logo", (Object)this.getLogo(this.logo));
            return;
        }
        SpecExpressionContext context = SpecExpressionContext.create((Object[])new Object[]{proxy, proxySpec, user, user.getPrincipal(), user.getCredentials()}).serverName(serverName).build();
        if (this.titleContainsExpression.booleanValue()) {
            map.put((Object)"title", (Object)this.expressionResolver.evaluateToString(this.title, context));
        } else {
            map.put((Object)"title", (Object)this.title);
        }
        if (this.logoContainsExpression.booleanValue()) {
            map.put((Object)"logo", (Object)this.getLogo(this.expressionResolver.evaluateToString(this.logo, context)));
        } else {
            map.put((Object)"logo", (Object)this.getLogo(this.logo));
        }
    }

    private String getLogo(String logo) {
        return ((Optional)this.logoCache.get((Object)logo, arg_0 -> this.resolveImageURI(arg_0))).orElse(null);
    }
}

