/*
 * Decompiled with CFR 0.152.
 */
package eu.openanalytics.shinyproxy.controllers;

import eu.openanalytics.containerproxy.api.dto.ApiResponse;
import eu.openanalytics.containerproxy.event.RemoveDelegateProxiesEvent;
import eu.openanalytics.shinyproxy.controllers.BaseController;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import javax.inject.Inject;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class DelegateProxyAdminController
extends BaseController {
    @Inject
    private ApplicationEventPublisher applicationEventPublisher;

    @Operation(summary="Stops DelegateProxies. Can only be used by admins. If no parameters are specified, all DelegateProxies (of all specs) are stopped. DelegateProxies that have claimed seats will be stopped as soon as all seats are released. New DelegateProxies are automatically created to meet the minimum number of seats.", tags={"ShinyProxy"})
    @ApiResponses(value={@io.swagger.v3.oas.annotations.responses.ApiResponse(responseCode="200", description="The DelegateProxies are being stopped.", content={@Content(mediaType="application/json", examples={@ExampleObject(value="{\"status\":\"success\", \"data\": null}")})}), @io.swagger.v3.oas.annotations.responses.ApiResponse(responseCode="400", description="Invalid request, no DelegateProxies are being stopped.", content={@Content(mediaType="application/json", examples={@ExampleObject(name="Both id and specId are specified, provide only a single parameter.", value="{\"status\":\"fail\",\"data\":\"Id and specId cannot be specified at the same time\"}")})}), @io.swagger.v3.oas.annotations.responses.ApiResponse(responseCode="403", description="Forbidden, you are not an admin user.", content={@Content(mediaType="application/json", examples={@ExampleObject(value="{\"status\": \"fail\", \"data\": \"forbidden\"}")})})})
    @RequestMapping(value={"/admin/delegate-proxy"}, produces={"application/json"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseEntity<ApiResponse<Object>> stopDelegateProxies(@Parameter(description="If specified stops the DelegateProxy with this id") @RequestParam(required=false) String id, @Parameter(description="If specified stops all DelegateProxies of this specId ") @RequestParam(required=false) String specId) {
        if (id != null && specId != null) {
            return ApiResponse.fail((Object)"Id and specId cannot be specified at the same time");
        }
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new RemoveDelegateProxiesEvent(id, specId));
        return ApiResponse.success();
    }
}

