/*
 * Decompiled with CFR 0.152.
 */
package eu.openanalytics.shinyproxy.controllers;

import eu.openanalytics.containerproxy.api.dto.ApiResponse;
import eu.openanalytics.containerproxy.model.runtime.Proxy;
import eu.openanalytics.containerproxy.service.ProxyService;
import eu.openanalytics.containerproxy.service.UserService;
import eu.openanalytics.containerproxy.service.heartbeat.ActiveProxiesService;
import eu.openanalytics.containerproxy.service.heartbeat.HeartbeatService;
import eu.openanalytics.shinyproxy.controllers.HeartbeatController;
import eu.openanalytics.shinyproxy.controllers.dto.ShinyProxyApiResponse;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import javax.inject.Inject;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class HeartbeatController {
    @Inject
    private HeartbeatService heartbeatService;
    @Inject
    private ProxyService proxyService;
    @Inject
    private UserService userService;
    @Inject
    private ActiveProxiesService activeProxiesService;

    @Operation(summary="Force an heartbeat for an app.", tags={"ShinyProxy"})
    @ApiResponses(value={@io.swagger.v3.oas.annotations.responses.ApiResponse(responseCode="200", description="Heartbeat sent.", content={@Content(mediaType="application/json", examples={@ExampleObject(value="{\"status\":\"success\", \"data\": null}")})}), @io.swagger.v3.oas.annotations.responses.ApiResponse(responseCode="401", description="User is not authenticated.", content={@Content(mediaType="application/json", examples={@ExampleObject(value="{\"message\":\"shinyproxy_authentication_required\",\"status\":\"fail\"}")})}), @io.swagger.v3.oas.annotations.responses.ApiResponse(responseCode="410", description="App has been stopped or the app never existed or the user has no access to the app.", content={@Content(mediaType="application/json", examples={@ExampleObject(value="{\"message\":\"app_stopped_or_non_existent\",\"status\":\"fail\"}")})})})
    @RequestMapping(value={"/heartbeat/{proxyId}"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public ResponseEntity<ApiResponse<Object>> heartbeat(@PathVariable(value="proxyId") String proxyId) {
        Proxy proxy = this.proxyService.getUserProxy(proxyId);
        if (proxy == null || proxy.getStatus().isUnavailable() || !this.userService.isOwner(proxy)) {
            return ShinyProxyApiResponse.appStoppedOrNonExistent();
        }
        this.heartbeatService.heartbeatReceived(HeartbeatService.HeartbeatSource.FALLBACK, proxy, null);
        return ApiResponse.success();
    }

    @Operation(summary="Get heartbeat information for an app.", tags={"ShinyProxy"})
    @ApiResponses(value={@io.swagger.v3.oas.annotations.responses.ApiResponse(responseCode="200", description="Heartbeat info returned.", content={@Content(mediaType="application/json", schema=@Schema(implementation=HeartBeatInfoDto.class), examples={@ExampleObject(value="{\"status\":\"success\",\"data\":{\"lastHeartbeat\":1704063600,\"heartbeatRate\":10000}}")})}), @io.swagger.v3.oas.annotations.responses.ApiResponse(responseCode="401", description="User is not authenticated.", content={@Content(mediaType="application/json", examples={@ExampleObject(value="{\"message\":\"shinyproxy_authentication_required\",\"status\":\"fail\"}")})}), @io.swagger.v3.oas.annotations.responses.ApiResponse(responseCode="410", description="App has been stopped or the app never existed or the user has no access to the app.", content={@Content(mediaType="application/json", examples={@ExampleObject(value="{\"message\":\"app_stopped_or_non_existent\",\"status\":\"fail\"}")})})})
    @RequestMapping(value={"/heartbeat/{proxyId}"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public ResponseEntity<ApiResponse<HeartBeatInfoDto>> getHeartbeatInfo(@PathVariable(value="proxyId") String proxyId) {
        Proxy proxy = this.proxyService.getUserProxy(proxyId);
        if (proxy == null || proxy.getStatus().isUnavailable() || !this.userService.isOwner(proxy)) {
            return ShinyProxyApiResponse.appStoppedOrNonExistent();
        }
        Long lastHeartbeat = this.activeProxiesService.getLastHeartBeat(proxy.getId());
        HeartBeatInfoDto resp = new HeartBeatInfoDto(lastHeartbeat, Long.valueOf(this.heartbeatService.getHeartbeatRate()));
        return ApiResponse.success((Object)resp);
    }
}

