/*
 * Decompiled with CFR 0.152.
 */
package eu.openanalytics.shinyproxy.controllers;

import eu.openanalytics.containerproxy.api.dto.ApiResponse;
import eu.openanalytics.containerproxy.model.runtime.Proxy;
import eu.openanalytics.containerproxy.model.runtime.ProxyStatus;
import eu.openanalytics.containerproxy.model.runtime.runtimevalues.RuntimeValue;
import eu.openanalytics.containerproxy.model.runtime.runtimevalues.RuntimeValueKey;
import eu.openanalytics.containerproxy.model.spec.ProxySpec;
import eu.openanalytics.containerproxy.model.store.IProxyStore;
import eu.openanalytics.containerproxy.service.AccessControlEvaluationService;
import eu.openanalytics.containerproxy.service.ProxyService;
import eu.openanalytics.containerproxy.service.StructuredLogger;
import eu.openanalytics.containerproxy.spec.expression.SpecExpressionContext;
import eu.openanalytics.shinyproxy.controllers.BaseController;
import eu.openanalytics.shinyproxy.controllers.dto.ChangeProxyUserIdDto;
import eu.openanalytics.shinyproxy.controllers.dto.ShinyProxyApiResponse;
import eu.openanalytics.shinyproxy.controllers.dto.SwaggerDto;
import eu.openanalytics.shinyproxy.runtimevalues.AppInstanceKey;
import eu.openanalytics.shinyproxy.runtimevalues.CustomAppDetail;
import eu.openanalytics.shinyproxy.runtimevalues.CustomAppDetails;
import eu.openanalytics.shinyproxy.runtimevalues.CustomAppDetailsKey;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.core.Authentication;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ProxyApiController
extends BaseController {
    @Inject
    private IProxyStore proxyStore;
    @Inject
    private ProxyService proxyService;
    @Inject
    private AccessControlEvaluationService accessControlEvaluationService;
    private final StructuredLogger slogger = StructuredLogger.create(this.getClass());

    @Operation(summary="Transfer an app to another user.", tags={"ShinyProxy"})
    @ApiResponses(value={@io.swagger.v3.oas.annotations.responses.ApiResponse(responseCode="200", description="App transferred.", content={@Content(mediaType="application/json", examples={@ExampleObject(value="{\"status\":\"success\", \"data\": null}")})}), @io.swagger.v3.oas.annotations.responses.ApiResponse(responseCode="401", description="User is not authenticated.", content={@Content(mediaType="application/json", examples={@ExampleObject(value="{\"message\":\"shinyproxy_authentication_required\",\"status\":\"fail\"}")})}), @io.swagger.v3.oas.annotations.responses.ApiResponse(responseCode="403", description="No permission to transfer app.", content={@Content(mediaType="application/json", examples={@ExampleObject(value="{\"status\": \"fail\", \"data\": \"forbidden\"}")})}), @io.swagger.v3.oas.annotations.responses.ApiResponse(responseCode="400", description="Cannot transfer app because no userId is provided in the request", content={@Content(mediaType="application/json", examples={@ExampleObject(value="{\"status\": \"fail\", \"data\": \"Cannot transfer app because no userId is provided in the request\"}")})}), @io.swagger.v3.oas.annotations.responses.ApiResponse(responseCode="400", description="Cannot transfer app because the proxy is already owned by this user", content={@Content(mediaType="application/json", examples={@ExampleObject(value="{\"status\": \"fail\", \"data\": \"Cannot transfer app because the proxy is already owned by this user\"}")})}), @io.swagger.v3.oas.annotations.responses.ApiResponse(responseCode="400", description="Cannot transfer app because it is not in Up status (status is Stopping)", content={@Content(mediaType="application/json", examples={@ExampleObject(value="{\"status\": \"fail\", \"data\": \"Cannot transfer app because it is not in Up status (status is Stopping)\"}")})})})
    @RequestMapping(value={"/api/proxy/{proxyId}/userId"}, method={RequestMethod.PUT}, produces={"application/json"})
    public ResponseEntity<ApiResponse<Proxy>> changeProxyUserId(@PathVariable String proxyId, @RequestBody ChangeProxyUserIdDto changeProxyUserIdDto) {
        if (!this.allowTransferApp.booleanValue()) {
            return ApiResponse.failForbidden();
        }
        Proxy proxy = this.proxyService.getProxy(proxyId);
        if (proxy == null || !this.userService.isOwner(proxy)) {
            return ApiResponse.failForbidden();
        }
        if (StringUtils.isBlank((CharSequence)changeProxyUserIdDto.getUserId())) {
            return ApiResponse.fail((Object)"Cannot transfer app because no userId is provided in the request");
        }
        if (!proxy.getStatus().equals((Object)ProxyStatus.Up)) {
            return ApiResponse.fail((Object)String.format("Cannot transfer app because it is not in Up status (status is %s)", proxy.getStatus()));
        }
        if (this.accessControlEvaluationService.usernameEquals(proxy.getUserId(), changeProxyUserIdDto.getUserId())) {
            return ApiResponse.fail((Object)"Cannot transfer app because the proxy is already owned by this user");
        }
        try {
            String instanceName = proxy.getRuntimeValue((RuntimeValueKey)AppInstanceKey.inst);
            if (instanceName.equals("_")) {
                instanceName = "Default";
            }
            instanceName = StringUtils.left((String)(proxy.getUserId() + "-" + instanceName), (int)64);
            this.proxyStore.removeProxy(proxy);
            proxy = proxy.toBuilder().userId(changeProxyUserIdDto.getUserId()).addRuntimeValue(new RuntimeValue((RuntimeValueKey)AppInstanceKey.inst, (Object)instanceName), true).build();
            this.proxyStore.addProxy(proxy);
        }
        catch (AccessDeniedException ex) {
            return ApiResponse.failForbidden();
        }
        return ApiResponse.success();
    }

    @Operation(summary="Get the custom app details for an app.", tags={"ShinyProxy"})
    @ApiResponses(value={@io.swagger.v3.oas.annotations.responses.ApiResponse(responseCode="200", description="Custom app details returned.", content={@Content(mediaType="application/json", schema=@Schema(implementation=SwaggerDto.CustomAppDetailsResponse.class), examples={@ExampleObject(value="{\"status\": \"success\", \"data\": [{\"name\": \"example_name\", \"description\": \"example_description\", \"value\": \"example_value\"}]}")})}), @io.swagger.v3.oas.annotations.responses.ApiResponse(responseCode="401", description="User is not authenticated.", content={@Content(mediaType="application/json", examples={@ExampleObject(value="{\"message\":\"shinyproxy_authentication_required\",\"status\":\"fail\"}")})}), @io.swagger.v3.oas.annotations.responses.ApiResponse(responseCode="410", description="App has been stopped or the app never existed or the user has no access to the app.", content={@Content(mediaType="application/json", examples={@ExampleObject(value="{\"message\":\"app_stopped_or_non_existent\",\"status\":\"fail\"}")})})})
    @RequestMapping(value={"/api/proxy/{proxyId}/details"}, produces={"application/json"})
    public ResponseEntity<ApiResponse<List<CustomAppDetail>>> proxyDetails(@PathVariable String proxyId, Authentication authentication) {
        Proxy proxy = this.proxyService.getUserProxy(proxyId);
        if (proxy == null || !this.userService.isOwner(proxy)) {
            return ShinyProxyApiResponse.appStoppedOrNonExistent();
        }
        CustomAppDetails customAppDetails = (CustomAppDetails)proxy.getRuntimeObjectOrNull((RuntimeValueKey)CustomAppDetailsKey.inst);
        if (customAppDetails == null || customAppDetails.isEmpty()) {
            return ApiResponse.success(List.of());
        }
        ProxySpec spec = this.proxyService.getUserSpec(proxy.getSpecId());
        SpecExpressionContext context = SpecExpressionContext.create((Object[])new Object[]{proxy, spec, authentication, authentication.getPrincipal(), authentication.getCredentials()}).build();
        ArrayList<CustomAppDetail> result = new ArrayList<CustomAppDetail>();
        for (CustomAppDetail customAppDetail : customAppDetails) {
            try {
                result.add(customAppDetail.toBuilder().value(this.expressionResolver.evaluateToString(customAppDetail.getValue(), context)).build());
            }
            catch (Exception e) {
                this.slogger.warn(proxy, (Throwable)e, String.format("Error while resolving CustomAppDetail expression '%s'", customAppDetail.getName()));
            }
        }
        return ApiResponse.success(result);
    }
}

