/*
 * Decompiled with CFR 0.152.
 */
package eu.openanalytics.shinyproxy.monitoring;

import eu.openanalytics.containerproxy.util.ProxyMappingManager;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.ResponseCodeHandler;
import io.undertow.server.handlers.proxy.LoadBalancingProxyClient;
import io.undertow.server.handlers.proxy.ProxyClient;
import io.undertow.server.handlers.proxy.ProxyHandler;
import java.net.URI;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.event.EventListener;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;

@Service
public class MonitoringService {
    private final ProxyMappingManager proxyMappingManager;
    private final URI grafanaUrl;

    public MonitoringService(ProxyMappingManager proxyMappingManager, Environment environment) {
        this.proxyMappingManager = proxyMappingManager;
        String url = environment.getProperty("proxy.monitoring.grafana-url");
        this.grafanaUrl = url != null ? new URI(StringUtils.removeEnd((String)url, (String)"/")) : null;
    }

    public boolean isEnabled() {
        return this.grafanaUrl != null;
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void init() {
        if (!this.isEnabled()) {
            return;
        }
        LoadBalancingProxyClient proxyClient = new LoadBalancingProxyClient();
        proxyClient.setMaxQueueSize(100);
        proxyClient.addHost(this.grafanaUrl);
        this.proxyMappingManager.getHttpHandler().addPrefixPath("/grafana_internal", (HttpHandler)new ProxyHandler((ProxyClient)proxyClient, (HttpHandler)ResponseCodeHandler.HANDLE_404));
    }
}

