/*
 * Decompiled with CFR 0.152.
 */
package eu.openanalytics.shinyproxy;

import io.undertow.UndertowMessages;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.protocol.http.ServerFixedLengthStreamSinkConduit;
import io.undertow.util.Headers;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import org.springframework.http.HttpStatus;
import org.xnio.IoUtils;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.conduits.AbstractStreamSinkConduit;
import org.xnio.conduits.ConduitWritableByteChannel;
import org.xnio.conduits.Conduits;
import org.xnio.conduits.StreamSinkConduit;

public class ShinyProxyIframeScriptInjector
extends AbstractStreamSinkConduit<StreamSinkConduit> {
    private final ByteArrayOutputStream outputStream;
    private final HttpServerExchange exchange;
    private final String scriptPath;

    public ShinyProxyIframeScriptInjector(StreamSinkConduit next, HttpServerExchange exchange, String scriptPath) {
        super(next);
        this.exchange = exchange;
        this.scriptPath = scriptPath;
        long length = exchange.getResponseContentLength();
        if (length <= 0L) {
            this.outputStream = new ByteArrayOutputStream();
        } else {
            if (length > Integer.MAX_VALUE) {
                throw UndertowMessages.MESSAGES.responseTooLargeToBuffer(Long.valueOf(length));
            }
            this.outputStream = new ByteArrayOutputStream((int)length);
        }
    }

    public long transferFrom(StreamSourceChannel source, long count, ByteBuffer throughBuffer) throws IOException {
        return IoUtils.transfer((ReadableByteChannel)source, (long)count, (ByteBuffer)throughBuffer, (WritableByteChannel)new ConduitWritableByteChannel((StreamSinkConduit)this));
    }

    public long transferFrom(FileChannel src, long position, long count) throws IOException {
        return src.transferTo(position, count, (WritableByteChannel)new ConduitWritableByteChannel((StreamSinkConduit)this));
    }

    public int write(ByteBuffer src) throws IOException {
        byte[] bytes = new byte[src.remaining()];
        src.get(bytes, 0, bytes.length);
        this.outputStream.write(bytes);
        return bytes.length;
    }

    public long write(ByteBuffer[] srcs, int offs, int len) throws IOException {
        for (int i = offs; i < len; ++i) {
            if (!srcs[i].hasRemaining()) continue;
            return this.write(srcs[i]);
        }
        return 0L;
    }

    public int writeFinal(ByteBuffer src) throws IOException {
        return Conduits.writeFinalBasic((StreamSinkConduit)this, (ByteBuffer)src);
    }

    public long writeFinal(ByteBuffer[] srcs, int offs, int len) throws IOException {
        return Conduits.writeFinalBasic((StreamSinkConduit)this, (ByteBuffer[])srcs, (int)offs, (int)len);
    }

    public void terminateWrites() throws IOException {
        ByteBuffer out;
        if (this.exchange.getStatusCode() == HttpStatus.OK.value() && this.exchange.getResponseHeaders().get("Content-Type") != null && this.exchange.getResponseHeaders().get("Content-Type").stream().anyMatch(headerValue -> headerValue.contains("text/html"))) {
            Object r = this.outputStream.toString(StandardCharsets.UTF_8);
            r = (String)r + "<script src='" + this.scriptPath + "'></script>";
            out = ByteBuffer.wrap(((String)r).getBytes(StandardCharsets.UTF_8));
        } else {
            out = ByteBuffer.wrap(this.outputStream.toByteArray());
        }
        this.updateContentLength(this.exchange, out);
        do {
            ((StreamSinkConduit)this.next).write(out);
        } while (out.hasRemaining());
        super.terminateWrites();
    }

    private void updateContentLength(HttpServerExchange exchange, ByteBuffer output) {
        long length = output.limit();
        if (!exchange.getResponseHeaders().contains("Transfer-Encoding")) {
            exchange.getResponseHeaders().put(Headers.CONTENT_LENGTH, length);
        }
        if (this.next instanceof ServerFixedLengthStreamSinkConduit) {
            Method m;
            try {
                m = ServerFixedLengthStreamSinkConduit.class.getDeclaredMethod("reset", Long.TYPE, HttpServerExchange.class);
                m.setAccessible(true);
            }
            catch (NoSuchMethodException | SecurityException ex) {
                throw new RuntimeException("could not find ServerFixedLengthStreamSinkConduit.reset method", ex);
            }
            try {
                m.invoke((Object)this.next, length, exchange);
            }
            catch (Throwable ex) {
                throw new RuntimeException("could not access BUFFERED_REQUEST_DATA field", ex);
            }
        }
    }
}

