/*
 * Decompiled with CFR 0.152.
 */
package eu.openanalytics.shinyproxy;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Scheduler;
import eu.openanalytics.containerproxy.model.runtime.runtimevalues.RuntimeValue;
import eu.openanalytics.containerproxy.model.runtime.runtimevalues.RuntimeValueKey;
import eu.openanalytics.containerproxy.model.spec.ISpecExtension;
import eu.openanalytics.containerproxy.model.spec.ProxySpec;
import eu.openanalytics.containerproxy.service.UserService;
import eu.openanalytics.containerproxy.spec.IProxySpecProvider;
import eu.openanalytics.containerproxy.spec.ISpecExtensionProvider;
import eu.openanalytics.containerproxy.spec.expression.SpecExpressionContext;
import eu.openanalytics.containerproxy.spec.expression.SpecExpressionResolver;
import eu.openanalytics.shinyproxy.ShinyProxySpecExtension;
import eu.openanalytics.shinyproxy.ShinyProxySpecProvider;
import eu.openanalytics.shinyproxy.runtimevalues.CustomAppDetails;
import eu.openanalytics.shinyproxy.runtimevalues.CustomAppDetailsKey;
import eu.openanalytics.shinyproxy.runtimevalues.ShinyForceFullReloadKey;
import eu.openanalytics.shinyproxy.runtimevalues.TrackAppUrl;
import eu.openanalytics.shinyproxy.runtimevalues.WebSocketReconnectionModeKey;
import eu.openanalytics.shinyproxy.runtimevalues.WebsocketReconnectionMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Primary;
import org.springframework.core.env.Environment;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;

@Component
@Primary
@ConfigurationProperties(prefix="proxy")
public class ShinyProxySpecProvider
implements IProxySpecProvider {
    private static final String PROP_DEFAULT_MAX_INSTANCES = "proxy.default-max-instances";
    private static final String PROP_DEFAULT_ALWAYS_SWITCH_INSTANCE = "proxy.default-always-switch-instance";
    private static Environment environment;
    private final Map<String, ProxySpec> specsMap = new HashMap();
    private final Cache<String, Map<String, Integer>> maxInstancesCache;
    private List<ProxySpec> specs = new ArrayList();
    private List<TemplateGroup> templateGroups = new ArrayList();
    private String defaultMaxInstances;
    private Boolean defaultAlwaysSwitchInstance;
    @Inject
    private SpecExpressionResolver expressionResolver;
    @Inject
    @Lazy
    private UserService userService;
    @Inject
    private List<ISpecExtensionProvider<?>> specExtensionProviders;

    public ShinyProxySpecProvider() {
        this.maxInstancesCache = Caffeine.newBuilder().scheduler(Scheduler.systemScheduler()).expireAfterAccess(60L, TimeUnit.MINUTES).build();
    }

    @Autowired
    public void setEnvironment(Environment env) {
        environment = env;
    }

    @PostConstruct
    public void afterPropertiesSet() {
        this.specs.stream().collect(Collectors.groupingBy(ProxySpec::getId)).forEach((id, duplicateSpecs) -> {
            if (duplicateSpecs.size() > 1) {
                throw new IllegalArgumentException(String.format("Configuration error: spec with id '%s' is defined multiple times", id));
            }
        });
        this.defaultMaxInstances = (String)environment.getProperty(PROP_DEFAULT_MAX_INSTANCES, String.class, (Object)"1");
        this.defaultAlwaysSwitchInstance = (Boolean)environment.getProperty(PROP_DEFAULT_ALWAYS_SWITCH_INSTANCE, Boolean.class, (Object)false);
        this.specs.forEach(ProxySpec::setContainerIndex);
        this.specs.forEach(spec -> this.specsMap.put(spec.getId(), spec));
        for (ISpecExtensionProvider specExtensionProvider : this.specExtensionProviders) {
            if (specExtensionProvider.getSpecs() == null) continue;
            for (ISpecExtension specExtension : specExtensionProvider.getSpecs()) {
                this.getSpec(specExtension.getId()).addSpecExtension(specExtension);
            }
        }
    }

    public List<ProxySpec> getSpecs() {
        return new ArrayList<ProxySpec>(this.specs);
    }

    public void setSpecs(List<ShinyProxySpec> specs) {
        this.specs = specs.stream().map(ShinyProxySpec::getProxySpec).toList();
    }

    public ProxySpec getSpec(String id) {
        if (id == null || id.isEmpty()) {
            return null;
        }
        return (ProxySpec)this.specsMap.get(id);
    }

    public List<TemplateGroup> getTemplateGroups() {
        return this.templateGroups;
    }

    public void setTemplateGroups(List<TemplateGroup> templateGroups) {
        this.templateGroups = templateGroups;
    }

    public List<RuntimeValue> getRuntimeValues(ProxySpec proxy) {
        ArrayList<RuntimeValue> runtimeValues = new ArrayList<RuntimeValue>();
        WebsocketReconnectionMode webSocketReconnectionMode = ((ShinyProxySpecExtension)proxy.getSpecExtension(ShinyProxySpecExtension.class)).getWebsocketReconnectionMode();
        if (webSocketReconnectionMode == null) {
            runtimeValues.add(new RuntimeValue((RuntimeValueKey)WebSocketReconnectionModeKey.inst, environment.getProperty("proxy.default-websocket-reconnection-mode", WebsocketReconnectionMode.class, (Object)WebsocketReconnectionMode.None)));
        } else {
            runtimeValues.add(new RuntimeValue((RuntimeValueKey)WebSocketReconnectionModeKey.inst, (Object)webSocketReconnectionMode));
        }
        runtimeValues.add(new RuntimeValue((RuntimeValueKey)ShinyForceFullReloadKey.inst, (Object)this.getShinyForceFullReload(proxy)));
        Boolean trackAppUrl = ((ShinyProxySpecExtension)proxy.getSpecExtension(ShinyProxySpecExtension.class)).getTrackAppUrl();
        if (trackAppUrl == null) {
            trackAppUrl = (Boolean)environment.getProperty("proxy.default-track-app-url", Boolean.class, (Object)false);
        }
        runtimeValues.add(new RuntimeValue((RuntimeValueKey)TrackAppUrl.inst, (Object)trackAppUrl));
        runtimeValues.add(new RuntimeValue((RuntimeValueKey)CustomAppDetailsKey.inst, (Object)new CustomAppDetails(((ShinyProxySpecExtension)proxy.getSpecExtension(ShinyProxySpecExtension.class)).getCustomAppDetails())));
        return runtimeValues;
    }

    public Integer getMaxInstancesForSpec(ProxySpec proxySpec) {
        return (Integer)this.getMaxInstances().get(proxySpec.getId());
    }

    public Map<String, Integer> getMaxInstances() {
        String sessionId = Objects.requireNonNull(RequestContextHolder.getRequestAttributes()).getSessionId();
        return (Map)this.maxInstancesCache.get((Object)sessionId, s -> {
            Authentication user = this.userService.getCurrentAuth();
            SpecExpressionContext context = SpecExpressionContext.create((Object[])new Object[]{user, user.getPrincipal(), user.getCredentials()}).build();
            HashMap<String, Integer> result = new HashMap<String, Integer>();
            Integer resolvedDefault = this.expressionResolver.evaluateToInteger(this.defaultMaxInstances, context);
            for (ProxySpec proxySpec : this.getSpecs()) {
                Integer maxInstances = (Integer)((ShinyProxySpecExtension)proxySpec.getSpecExtension(ShinyProxySpecExtension.class)).getMaxInstances().resolve(this.expressionResolver, context).getValueOrNull();
                if (maxInstances != null) {
                    result.put(proxySpec.getId(), maxInstances);
                    continue;
                }
                result.put(proxySpec.getId(), resolvedDefault);
            }
            return result;
        });
    }

    public Boolean getShinyForceFullReload(ProxySpec proxySpec) {
        Boolean shinyProxyForceFullReload = ((ShinyProxySpecExtension)proxySpec.getSpecExtension(ShinyProxySpecExtension.class)).getShinyForceFullReload();
        if (shinyProxyForceFullReload != null) {
            return shinyProxyForceFullReload;
        }
        return false;
    }

    public Boolean getHideNavbarOnMainPageLink(ProxySpec proxySpec) {
        Boolean hideNavbarOnMainPageLink = ((ShinyProxySpecExtension)proxySpec.getSpecExtension(ShinyProxySpecExtension.class)).getHideNavbarOnMainPageLink();
        if (hideNavbarOnMainPageLink != null) {
            return hideNavbarOnMainPageLink;
        }
        return false;
    }

    public Boolean getAlwaysShowSwitchInstance(ProxySpec proxySpec) {
        Boolean alwaysShowSwitchInstance = ((ShinyProxySpecExtension)proxySpec.getSpecExtension(ShinyProxySpecExtension.class)).getAlwaysShowSwitchInstance();
        if (alwaysShowSwitchInstance != null) {
            return alwaysShowSwitchInstance;
        }
        return this.defaultAlwaysSwitchInstance;
    }
}

