/*
 * Decompiled with CFR 0.152.
 */
package eu.openanalytics.shinyproxy;

import eu.openanalytics.containerproxy.model.spec.ProxySpec;
import eu.openanalytics.containerproxy.service.UserService;
import eu.openanalytics.containerproxy.util.CleanHtml;
import eu.openanalytics.shinyproxy.ShinyProxySpecExtension;
import eu.openanalytics.shinyproxy.ShinyProxySpecProvider;
import eu.openanalytics.shinyproxy.Thymeleaf;
import eu.openanalytics.shinyproxy.external.ExternalAppSpecExtension;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.springframework.web.util.UriComponentsBuilder;

@Component
public class Thymeleaf {
    @Inject
    private ShinyProxySpecProvider shinyProxySpecProvider;
    @Inject
    private UserService userService;

    public String getAppUrl(ProxySpec proxySpec) {
        String externalUrl = ((ExternalAppSpecExtension)proxySpec.getSpecExtension(ExternalAppSpecExtension.class)).getExternalUrl();
        if (externalUrl != null && !externalUrl.isBlank()) {
            return externalUrl;
        }
        UriComponentsBuilder builder = ServletUriComponentsBuilder.fromCurrentContextPath().pathSegment(new String[]{"app", proxySpec.getId()});
        if (this.shinyProxySpecProvider.getHideNavbarOnMainPageLink(proxySpec).booleanValue()) {
            builder.queryParam("sp_hide_navbar", new Object[]{"true"});
        }
        return builder.toUriString();
    }

    public boolean openSwitchInstanceInsteadOfApp(ProxySpec proxySpec) {
        return this.shinyProxySpecProvider.getAlwaysShowSwitchInstance(proxySpec);
    }

    public String getTemplateProperty(String specId, String property) {
        ProxySpec proxySpec = this.shinyProxySpecProvider.getSpec(specId);
        if (proxySpec == null) {
            return null;
        }
        return (String)((ShinyProxySpecExtension)proxySpec.getSpecExtension(ShinyProxySpecExtension.class)).getTemplateProperties().get(property);
    }

    public String getTemplateProperty(String specId, String property, String defaultValue) {
        String res = this.getTemplateProperty(specId, property);
        if (res != null) {
            return res;
        }
        return defaultValue;
    }

    public List<ProxySpec> getAllApps() {
        return this.shinyProxySpecProvider.getSpecs();
    }

    public List<ProxySpec> getAllUnauthorizedApps() {
        return this.shinyProxySpecProvider.getSpecs().stream().filter(spec -> !this.userService.canAccess(spec)).toList();
    }

    public GroupedProxySpecs groupApps(List<ProxySpec> apps) {
        HashMap groupedApps = new HashMap();
        ArrayList<ProxySpec> ungroupedApps = new ArrayList<ProxySpec>();
        for (ProxySpec app : apps) {
            String groupId = ((ShinyProxySpecExtension)app.getSpecExtension(ShinyProxySpecExtension.class)).getTemplateGroup();
            if (groupId != null) {
                groupedApps.putIfAbsent(groupId, new ArrayList());
                ((ArrayList)groupedApps.get(groupId)).add(app);
                continue;
            }
            ungroupedApps.add(app);
        }
        List<ShinyProxySpecProvider.TemplateGroup> templateGroups = this.shinyProxySpecProvider.getTemplateGroups().stream().filter(g -> groupedApps.containsKey(g.getId())).toList();
        return new GroupedProxySpecs(apps.stream().map(ProxySpec::getId).toList(), apps, templateGroups, groupedApps, ungroupedApps);
    }

    public String cleanHtml(String html) {
        return CleanHtml.clean((String)html);
    }
}

