/*
 * Decompiled with CFR 0.152.
 */
package eu.openanalytics.shinyproxy.controllers;

import eu.openanalytics.containerproxy.api.dto.ApiResponse;
import eu.openanalytics.containerproxy.service.heartbeat.ActiveProxiesService;
import eu.openanalytics.shinyproxy.controllers.AdminController;
import eu.openanalytics.shinyproxy.controllers.BaseController;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import jakarta.servlet.http.HttpServletRequest;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.List;
import javax.inject.Inject;
import org.apache.commons.io.FileUtils;
import org.springframework.boot.info.BuildProperties;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class AdminController
extends BaseController {
    @Inject
    private ActiveProxiesService activeProxiesService;
    @Inject
    private BuildProperties buildProperties;

    @RequestMapping(value={"/admin"})
    private String admin(ModelMap map, HttpServletRequest request) {
        this.prepareMap(map, request);
        map.put((Object)"page", (Object)"admin");
        map.put((Object)"subPage", (Object)"main");
        return "admin";
    }

    @RequestMapping(value={"/admin/about"})
    private String adminAbout(ModelMap map, HttpServletRequest request) {
        this.prepareMap(map, request);
        map.put((Object)"page", (Object)"admin");
        map.put((Object)"subPage", (Object)"about");
        RuntimeMXBean runtimeMxBean = ManagementFactory.getRuntimeMXBean();
        List<String> arguments = runtimeMxBean.getInputArguments();
        map.put((Object)"runtimeId", (Object)this.identifierService.runtimeId);
        map.put((Object)"instanceId", (Object)this.identifierService.instanceId);
        map.put((Object)"realmId", (Object)this.identifierService.realmId);
        map.put((Object)"shinyProxyVersion", (Object)this.buildProperties.getVersion());
        map.put((Object)"containerProxyVersion", (Object)this.buildProperties.get("containerProxyVersion"));
        map.put((Object)"jvmVersion", (Object)(runtimeMxBean.getVmName() + " (" + runtimeMxBean.getVmVendor() + ") " + Runtime.version().toString()));
        map.put((Object)"jvmArguments", (Object)String.join((CharSequence)"\n", arguments));
        map.put((Object)"heapSize", (Object)FileUtils.byteCountToDisplaySize((long)Runtime.getRuntime().totalMemory()));
        map.put((Object)"heapFreeSize", (Object)FileUtils.byteCountToDisplaySize((long)Runtime.getRuntime().freeMemory()));
        map.put((Object)"heapMaxSize", (Object)FileUtils.byteCountToDisplaySize((long)Runtime.getRuntime().maxMemory()));
        return "admin";
    }

    @Operation(summary="Get active proxies of all users.", tags={"ShinyProxy"})
    @ApiResponses(value={@io.swagger.v3.oas.annotations.responses.ApiResponse(responseCode="200", description="Active proxies are returned.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ProxyInfoResponse.class), examples={@ExampleObject(value="{\"status\": \"success\", \"data\": [{\"status\": \"Up\", \"proxyId\": \"9cd90bbb-ae9c-4016-9b9c-d2852b3a0bf6\", \"userId\": \"jack\", \"appName\": \"01_hello\", \"instanceName\": \"Default\", \"endpoint\": \"N/A\", \"uptime\": \"0:00:39\", \"lastHeartBeat\": \"0:00:05\", \"imageName\": \"openanalytics/shinyproxy-demo\", \"imageTag\": \"N/A\", \"heartbeatTimeout\": null, \"maxLifetime\": \"0:02:00\", \"spInstance\": \"9bec0d32754eab6a036bf1ee032bca82f98df0c5\", \"backendContainerName\": \"900b4f35b283401946db1d7cb8fe31ad5e6209d921b3cb9fd668ed6b9cbf7aa5\", \"parameters\": null}, {\"status\": \"Up\", \"proxyId\": \"b34d416e-ce6e-4351-a126-8836c88f2200\", \"userId\": \"jack\", \"appName\": \"06_tabsets\", \"instanceName\": \"Default\", \"endpoint\": \"N/A\", \"uptime\": \"0:00:18\", \"lastHeartBeat\": \"0:00:02\", \"imageName\": \"openanalytics/shinyproxy-demo\", \"imageTag\": \"N/A\", \"heartbeatTimeout\": null, \"maxLifetime\": \"0:02:00\", \"spInstance\": \"9bec0d32754eab6a036bf1ee032bca82f98df0c5\", \"backendContainerName\": \"2158b5b49c4138a9d0d6313fc4b62eba074b359473143be1d98102ab06c74bf8\", \"parameters\": null}]}")})})})
    @RequestMapping(value={"/admin/data"}, produces={"application/json"}, method={RequestMethod.GET})
    @ResponseBody
    private ResponseEntity<ApiResponse<List<ProxyInfo>>> adminData() {
        List proxies = this.proxyService.getAllProxies();
        List<ProxyInfo> proxyInfos = proxies.stream().map(x$0 -> new ProxyInfo(this, x$0)).toList();
        return ApiResponse.success(proxyInfos);
    }
}

