/*
 * Decompiled with CFR 0.152.
 */
package eu.openanalytics.shinyproxy.controllers;

import com.fasterxml.jackson.annotation.JsonView;
import com.fasterxml.jackson.databind.ObjectMapper;
import eu.openanalytics.containerproxy.ProxyStartValidationException;
import eu.openanalytics.containerproxy.api.dto.ApiResponse;
import eu.openanalytics.containerproxy.api.dto.SwaggerDto;
import eu.openanalytics.containerproxy.model.Views;
import eu.openanalytics.containerproxy.model.runtime.AllowedParametersForUser;
import eu.openanalytics.containerproxy.model.runtime.ParameterValues;
import eu.openanalytics.containerproxy.model.runtime.PortMappings;
import eu.openanalytics.containerproxy.model.runtime.Proxy;
import eu.openanalytics.containerproxy.model.runtime.runtimevalues.DisplayNameKey;
import eu.openanalytics.containerproxy.model.runtime.runtimevalues.ParameterValuesKey;
import eu.openanalytics.containerproxy.model.runtime.runtimevalues.PortMappingsKey;
import eu.openanalytics.containerproxy.model.runtime.runtimevalues.PublicPathKey;
import eu.openanalytics.containerproxy.model.runtime.runtimevalues.RuntimeValue;
import eu.openanalytics.containerproxy.model.runtime.runtimevalues.RuntimeValueKey;
import eu.openanalytics.containerproxy.model.spec.ContainerSpec;
import eu.openanalytics.containerproxy.model.spec.ProxySpec;
import eu.openanalytics.containerproxy.service.AsyncProxyService;
import eu.openanalytics.containerproxy.service.InvalidParametersException;
import eu.openanalytics.containerproxy.service.ParametersService;
import eu.openanalytics.containerproxy.util.ProxyMappingManager;
import eu.openanalytics.shinyproxy.AppRequestInfo;
import eu.openanalytics.shinyproxy.ShinyProxyIframeScriptInjector;
import eu.openanalytics.shinyproxy.controllers.AppController;
import eu.openanalytics.shinyproxy.controllers.BaseController;
import eu.openanalytics.shinyproxy.controllers.dto.ShinyProxyApiResponse;
import eu.openanalytics.shinyproxy.external.ExternalAppSpecExtension;
import eu.openanalytics.shinyproxy.runtimevalues.AppInstanceKey;
import eu.openanalytics.shinyproxy.runtimevalues.UserTimeZoneKey;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.undertow.util.HttpString;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.springframework.web.servlet.view.RedirectView;
import org.springframework.web.util.UriComponentsBuilder;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.ExpressionContext;
import org.thymeleaf.context.IContext;
import org.thymeleaf.dialect.IDialect;
import org.thymeleaf.spring6.dialect.SpringStandardDialect;
import org.thymeleaf.templatemode.TemplateMode;
import org.thymeleaf.templateresolver.ITemplateResolver;
import org.thymeleaf.templateresolver.StringTemplateResolver;
import org.xnio.conduits.StreamSinkConduit;

@Controller
public class AppController
extends BaseController {
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final HttpString acceptEncodingHeader = new HttpString("Accept-Encoding");
    @Inject
    private ProxyMappingManager mappingManager;
    @Inject
    private AsyncProxyService asyncProxyService;
    @Inject
    private ParametersService parameterService;
    private int pathPrefixLength = 0;

    public AppController() {
        this.objectMapper.setConfig(this.objectMapper.getSerializationConfig().withView(Views.UserApi.class));
    }

    @PostConstruct
    public void init() {
        this.pathPrefixLength = this.getBasePublicPath().length() + 36 + 1;
    }

    @RequestMapping(value={"/app/{appName}/{*subPath}"}, method={RequestMethod.GET})
    public ModelAndView app(ModelMap map, HttpServletRequest request, @PathVariable String appName, @PathVariable String subPath) {
        return this.app(map, request, appName, "_", "/app/" + appName, subPath);
    }

    @RequestMapping(value={"/app_i/{appName}/{appInstance}/{*subPath}"}, method={RequestMethod.GET})
    public ModelAndView app(ModelMap map, HttpServletRequest request, @PathVariable String appName, @PathVariable String appInstance, @PathVariable String subPath) {
        return this.app(map, request, appName, appInstance, "/app_i/" + appName + "/" + appInstance, subPath);
    }

    private ModelAndView app(ModelMap map, HttpServletRequest request, String appName, String appInstance, String appPath, String subPath) {
        Proxy proxy = this.findUserProxy(appName, appInstance);
        ProxySpec spec = this.proxyService.getUserSpec(appName);
        if (proxy == null && spec == null) {
            request.setAttribute("jakarta.servlet.error.status_code", (Object)HttpStatus.FORBIDDEN.value());
            return new ModelAndView("forward:/error");
        }
        Optional redirect = this.createRedirectIfRequired(request, subPath, spec, proxy);
        if (redirect.isPresent()) {
            return new ModelAndView((View)redirect.get());
        }
        this.prepareMap(map, request, spec, proxy);
        map.put((Object)"heartbeatRate", (Object)this.heartbeatRate);
        map.put((Object)"page", (Object)"app");
        map.put((Object)"appName", (Object)appName);
        map.put((Object)"appInstance", (Object)appInstance);
        map.put((Object)"appPath", (Object)appPath);
        map.put((Object)"containerSubPath", (Object)this.buildContainerSubPath(request, subPath));
        map.put((Object)"refreshOpenidEnabled", (Object)this.authenticationBackend.getName().equals("openid"));
        ParameterValues previousParameters = null;
        if (proxy == null || proxy.getRuntimeObjectOrNull((RuntimeValueKey)DisplayNameKey.inst) == null) {
            if (spec == null) {
                map.put((Object)"appTitle", (Object)"ShinyProxy");
            } else if (spec.getDisplayName() == null || spec.getDisplayName().isEmpty()) {
                map.put((Object)"appTitle", (Object)spec.getId());
            } else {
                map.put((Object)"appTitle", (Object)spec.getDisplayName());
            }
        } else {
            map.put((Object)"appTitle", (Object)proxy.getRuntimeValue((RuntimeValueKey)DisplayNameKey.inst));
            previousParameters = (ParameterValues)proxy.getRuntimeObjectOrNull((RuntimeValueKey)ParameterValuesKey.inst);
        }
        map.put((Object)"proxy", this.secureProxy(proxy));
        if (spec != null && spec.getParameters() != null) {
            Authentication auth = SecurityContextHolder.getContext().getAuthentication();
            AllowedParametersForUser allowedParametersForUser = this.parameterService.calculateAllowedParametersForUser(auth, spec, previousParameters);
            map.put((Object)"parameterAllowedCombinations", (Object)allowedParametersForUser.getAllowedCombinations());
            map.put((Object)"parameterValues", (Object)allowedParametersForUser.getValues());
            map.put((Object)"parameterDefaults", (Object)allowedParametersForUser.getDefaultValue());
            map.put((Object)"parameterDefinitions", (Object)spec.getParameters().getDefinitions());
            map.put((Object)"parameterIds", (Object)spec.getParameters().getIds());
            if (spec.getParameters().getTemplate() != null) {
                map.put((Object)"parameterFragment", (Object)this.renderParameterTemplate(spec.getParameters().getTemplate(), map));
            } else {
                map.put((Object)"parameterFragment", null);
            }
        } else {
            map.put((Object)"parameterValues", null);
            map.put((Object)"parameterDefaults", null);
            map.put((Object)"parameterDefinitions", null);
            map.put((Object)"parameterIds", null);
            map.put((Object)"parameterFragment", null);
        }
        return new ModelAndView("app", (Map)map);
    }

    @Operation(summary="Start an app.", tags={"ShinyProxy"}, requestBody=@RequestBody(content={@Content(mediaType="application/json", schema=@Schema(implementation=AppBody.class), examples={@ExampleObject(name="With parameters", value="{\"parameters\":{\"resources\":\"2 CPU cores - 8G RAM\",\"other_parameter\":\"example\"}}"), @ExampleObject(name="With timezone", value="{\"timezone\":\"Europe/Brussels\"}")})}))
    @ApiResponses(value={@io.swagger.v3.oas.annotations.responses.ApiResponse(responseCode="200", description="The proxy has been created.", content={@Content(mediaType="application/json", schema=@Schema(implementation=SwaggerDto.ProxyResponse.class), examples={@ExampleObject(value="{\"status\":\"success\",\"data\":{\"id\":\"cdaa8056-4f96-428e-91e8-bc13518d8987\",\"status\":\"New\",\"startupTimestamp\":0,\"createdTimestamp\":1671707875757,\"userId\":\"jack\",\"specId\":\"01_hello\",\"displayName\":\"Hello Application\",\"containers\":[],\"runtimeValues\":{\"SHINYPROXY_FORCE_FULL_RELOAD\":false,\"SHINYPROXY_WEBSOCKET_RECONNECTION_MODE\":\"None\",\"SHINYPROXY_MAX_INSTANCES\":100,\"SHINYPROXY_PUBLIC_PATH\":\"/app_proxy/cdaa8056-4f96-428e-91e8-bc13518d8987/\",\"SHINYPROXY_APP_INSTANCE\":\"default\"}}}\n")})}), @io.swagger.v3.oas.annotations.responses.ApiResponse(responseCode="400", description="Invalid request, app not started.", content={@Content(mediaType="application/json", examples={@ExampleObject(name="Max instances reached", value="{\"status\":\"fail\",\"data\":\"Cannot start new proxy because the maximum amount of instances of this proxy has been reached\"}"), @ExampleObject(name="Instance already exists", value="{\"status\":\"fail\",\"data\":\"You already have an instance of this app with the given name\"}"), @ExampleObject(name="Parameters required", value="{\"status\":\"fail\",\"data\":\"No parameters provided, but proxy spec expects parameters\"}"), @ExampleObject(name="Missing parameter", value="{\"status\":\"fail\",\"data\":\"Missing value for parameter example\"}"), @ExampleObject(name="Invalid parameter value", value="{\"status\":\"fail\",\"data\":\"Provided parameter values are not allowed\"}")})}), @io.swagger.v3.oas.annotations.responses.ApiResponse(responseCode="403", description="Proxy spec not found or no permission to use this proxy spec.", content={@Content(mediaType="application/json", examples={@ExampleObject(value="{\"status\": \"fail\", \"data\": \"forbidden\"}")})}), @io.swagger.v3.oas.annotations.responses.ApiResponse(responseCode="500", description="Failed to start proxy.", content={@Content(mediaType="application/json", examples={@ExampleObject(value="{\"status\": \"fail\", \"data\": \"Failed to start proxy\"}")})})})
    @ResponseBody
    @JsonView(value={Views.UserApi.class})
    @RequestMapping(value={"/app_i/{specId}/{appInstanceName}"}, method={RequestMethod.POST})
    public ResponseEntity<ApiResponse<Proxy>> startApp(@PathVariable String specId, @PathVariable String appInstanceName, @org.springframework.web.bind.annotation.RequestBody(required=false) AppBody appBody) {
        ProxySpec spec = this.proxyService.getUserSpec(specId);
        if (!this.userService.canAccess(spec)) {
            return ApiResponse.failForbidden();
        }
        if (appInstanceName.length() > 64 || !AppRequestInfo.INSTANCE_NAME_PATTERN.matcher(appInstanceName).matches()) {
            return ApiResponse.fail((Object)"Invalid app instance name");
        }
        Proxy proxy = this.findUserProxy(specId, appInstanceName);
        if (proxy != null) {
            return ApiResponse.fail((Object)"You already have an instance of this app with the given name");
        }
        if (!this.validateMaxInstances(spec)) {
            Integer maxInstances = this.shinyProxySpecProvider.getMaxInstancesForSpec(spec);
            return ApiResponse.fail((Object)String.format("Cannot start this app because you are using the maximum number of instances (%s) of this app.", maxInstances));
        }
        List runtimeValues = this.shinyProxySpecProvider.getRuntimeValues(spec);
        String id = UUID.randomUUID().toString();
        runtimeValues.add(new RuntimeValue((RuntimeValueKey)PublicPathKey.inst, (Object)this.getPublicPath(id)));
        runtimeValues.add(new RuntimeValue((RuntimeValueKey)AppInstanceKey.inst, (Object)appInstanceName));
        if (appBody != null && appBody.getTimezone() != null) {
            runtimeValues.add(new RuntimeValue((RuntimeValueKey)UserTimeZoneKey.inst, (Object)appBody.getTimezone()));
        }
        try {
            return ApiResponse.success((Object)this.asyncProxyService.startProxy(spec, runtimeValues, id, appBody != null ? appBody.getParameters() : null));
        }
        catch (ProxyStartValidationException | InvalidParametersException ex) {
            return ApiResponse.fail((Object)ex.getMessage());
        }
        catch (Throwable t) {
            return ApiResponse.error((Object)"Failed to start proxy");
        }
    }

    @Operation(summary="Proxy request to app. This endpoint is used to serve the iframe, hence it makes some assumptions. Do not use it directly or for embedding.", tags={"ShinyProxy"})
    @ApiResponses(value={@io.swagger.v3.oas.annotations.responses.ApiResponse(responseCode="401", description="User is not authenticated.", content={@Content(mediaType="application/json", examples={@ExampleObject(value="{\"message\":\"shinyproxy_authentication_required\",\"status\":\"fail\"}")})}), @io.swagger.v3.oas.annotations.responses.ApiResponse(responseCode="410", description="App has been stopped or the app never existed or the user has no access to the app.", content={@Content(mediaType="application/json", examples={@ExampleObject(value="{\"message\":\"app_stopped_or_non_existent\",\"status\":\"fail\"}")})})})
    @RequestMapping(value={"/app_proxy/{targetId}/**"})
    public void appProxy(@PathVariable String targetId, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String subPath = this.extractSubPath(targetId, request);
        if (subPath == null) {
            ShinyProxyApiResponse.appStoppedOrNonExistent((HttpServletResponse)response);
            return;
        }
        String proxyId = this.extractQueryParameter(request, "sp_proxy_id");
        Proxy proxy = proxyId != null ? this.proxyService.getUserProxy(proxyId) : this.userAndTargetIdProxyIndex.getProxy(this.userService.getCurrentUserId(), targetId);
        if (proxy == null || proxy.getStatus().isUnavailable() || !this.userService.isOwner(proxy)) {
            ShinyProxyApiResponse.appStoppedOrNonExistent((HttpServletResponse)response);
            return;
        }
        try {
            this.mappingManager.dispatchAsync(proxy, subPath, request, response);
        }
        catch (Exception e) {
            throw new RuntimeException("Error routing proxy request", e);
        }
    }

    @RequestMapping(value={"/app_proxy/{targetId}/**"}, produces={"text/html"}, method={RequestMethod.GET})
    public void appProxyHtml(@PathVariable String targetId, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String subPath = this.extractSubPath(targetId, request);
        if (subPath == null) {
            ShinyProxyApiResponse.appStoppedOrNonExistent((HttpServletResponse)response);
            return;
        }
        Proxy proxy = this.userAndTargetIdProxyIndex.getProxy(this.userService.getCurrentUserId(), targetId);
        if (proxy == null || proxy.getStatus().isUnavailable() || !this.userService.isOwner(proxy)) {
            ShinyProxyApiResponse.appStoppedOrNonExistent((HttpServletResponse)response);
            return;
        }
        String secFetchMode = request.getHeader("Sec-Fetch-Mode");
        if (secFetchMode != null && !secFetchMode.equals("navigate")) {
            try {
                this.mappingManager.dispatchAsync(proxy, subPath, request, response);
                return;
            }
            catch (Exception e) {
                throw new RuntimeException("Error routing proxy request", e);
            }
        }
        try {
            String scriptPath = this.contextPathHelper.withEndingSlash() + this.identifierService.instanceId + "/js/shiny.iframe.js";
            this.mappingManager.dispatchAsync(proxy, subPath, request, response, exchange -> {
                exchange.getRequestHeaders().put(this.acceptEncodingHeader, "identity");
                exchange.addResponseWrapper((factory, exchange1) -> new ShinyProxyIframeScriptInjector((StreamSinkConduit)factory.create(), exchange1, scriptPath));
            });
        }
        catch (Exception e) {
            throw new RuntimeException("Error routing proxy request", e);
        }
    }

    private String extractQueryParameter(HttpServletRequest request, String name) {
        MultiValueMap params = ServletUriComponentsBuilder.fromRequest((HttpServletRequest)request).build().getQueryParams();
        if (!params.containsKey((Object)name)) {
            return null;
        }
        return (String)params.getFirst((Object)name);
    }

    private String buildContainerSubPath(HttpServletRequest request, String subPath) {
        String queryString = ServletUriComponentsBuilder.fromRequest((HttpServletRequest)request).replaceQueryParam("sp_hide_navbar", new Object[0]).replaceQueryParam("sp_automatic_reload", new Object[0]).build().getQuery();
        String res = UriComponentsBuilder.fromPath((String)subPath).query(queryString).build(false).toUriString();
        if (res.startsWith("/")) {
            return res.substring(1);
        }
        return res;
    }

    private String extractSubPath(String targetId, HttpServletRequest request) {
        if (targetId.length() != 36) {
            return null;
        }
        return request.getRequestURI().substring(this.pathPrefixLength);
    }

    private String getBasePublicPath() {
        return this.contextPathHelper.withEndingSlash() + "app_proxy/";
    }

    private String getPublicPath(String targetId) {
        return this.getBasePublicPath() + targetId + "/";
    }

    private Optional<RedirectView> createRedirectIfRequired(HttpServletRequest request, String subPath, ProxySpec spec, Proxy proxy) {
        String externalUrl;
        if (spec != null && (externalUrl = ((ExternalAppSpecExtension)spec.getSpecExtension(ExternalAppSpecExtension.class)).getExternalUrl()) != null) {
            return Optional.of(new RedirectView(externalUrl));
        }
        if (subPath.isEmpty() || subPath.equals("/")) {
            return Optional.empty();
        }
        String trimmedSubPath = subPath.substring(1);
        if (trimmedSubPath.contains("/")) {
            return Optional.empty();
        }
        boolean isMappingWithoutSlash = proxy != null ? ((PortMappings)proxy.getContainer(Integer.valueOf(0)).getRuntimeObject((RuntimeValueKey)PortMappingsKey.inst)).getPortMappings().stream().anyMatch(it -> it.getName().equals(trimmedSubPath)) : (spec != null ? ((ContainerSpec)spec.getContainerSpecs().getFirst()).getPortMapping().stream().anyMatch(it -> it.getName().equals(trimmedSubPath)) : false);
        if (isMappingWithoutSlash) {
            String uri = ServletUriComponentsBuilder.fromRequest((HttpServletRequest)request).path("/").build().toUriString();
            return Optional.of(new RedirectView(uri));
        }
        return Optional.empty();
    }

    private String renderParameterTemplate(String template, ModelMap map) {
        TemplateEngine templateEngine = new TemplateEngine();
        StringTemplateResolver stringTemplateResolver = new StringTemplateResolver();
        stringTemplateResolver.setTemplateMode(TemplateMode.HTML);
        stringTemplateResolver.setCacheable(false);
        templateEngine.setTemplateResolver((ITemplateResolver)stringTemplateResolver);
        templateEngine.setDialect((IDialect)new SpringStandardDialect());
        ExpressionContext context = new ExpressionContext(templateEngine.getConfiguration(), null, (Map)map);
        return templateEngine.process(template, (IContext)context);
    }

    private Object secureProxy(Proxy proxy) {
        return this.objectMapper.convertValue((Object)proxy, Object.class);
    }
}

