/*
 * Decompiled with CFR 0.152.
 */
package eu.openanalytics.shinyproxy.controllers;

import eu.openanalytics.containerproxy.ContainerProxyException;
import eu.openanalytics.containerproxy.model.runtime.Proxy;
import eu.openanalytics.containerproxy.model.runtime.ProxyStatus;
import eu.openanalytics.containerproxy.model.runtime.runtimevalues.PublicPathKey;
import eu.openanalytics.containerproxy.model.runtime.runtimevalues.RuntimeValue;
import eu.openanalytics.containerproxy.model.runtime.runtimevalues.RuntimeValueKey;
import eu.openanalytics.containerproxy.model.spec.ProxySpec;
import eu.openanalytics.containerproxy.service.InvalidParametersException;
import eu.openanalytics.containerproxy.util.ProxyMappingManager;
import eu.openanalytics.shinyproxy.AppRequestInfo;
import eu.openanalytics.shinyproxy.controllers.BaseController;
import eu.openanalytics.shinyproxy.runtimevalues.AppInstanceKey;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import java.util.UUID;
import javax.inject.Inject;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class AppDirectController
extends BaseController {
    @Inject
    private ProxyMappingManager mappingManager;

    @Operation(summary="Proxy request to app. Starts the app if it does not yet exists. Can be used directly or for embedding.", tags={"ShinyProxy"})
    @RequestMapping(value={"/app_direct_i/**", "/app_direct/**"})
    public void appDirect(HttpServletRequest request, HttpServletResponse response) throws InvalidParametersException, ServletException, IOException {
        AppRequestInfo appRequestInfo = AppRequestInfo.fromRequestOrNull((HttpServletRequest)request);
        if (appRequestInfo == null) {
            request.setAttribute("jakarta.servlet.error.status_code", (Object)HttpStatus.FORBIDDEN.value());
            request.getRequestDispatcher("/error").forward((ServletRequest)request, (ServletResponse)response);
            return;
        }
        if (appRequestInfo.getSubPath() == null) {
            try {
                response.sendRedirect(request.getRequestURI() + "/");
            }
            catch (Exception e) {
                throw new RuntimeException("Error redirecting proxy request", e);
            }
            return;
        }
        Proxy proxy = this.getOrStart(appRequestInfo, request, response);
        if (proxy == null) {
            return;
        }
        try {
            this.mappingManager.dispatchAsync(proxy, appRequestInfo.getSubPath(), request, response);
        }
        catch (Exception e) {
            throw new RuntimeException("Error routing proxy request", e);
        }
    }

    private Proxy getOrStart(AppRequestInfo appRequestInfo, HttpServletRequest request, HttpServletResponse response) throws InvalidParametersException, ServletException, IOException {
        Proxy proxy = this.findUserProxy(appRequestInfo);
        if (proxy == null) {
            ProxySpec spec = this.proxyService.getUserSpec(appRequestInfo.getAppName());
            if (spec == null) {
                request.setAttribute("jakarta.servlet.error.status_code", (Object)HttpStatus.FORBIDDEN.value());
                request.getRequestDispatcher("/error").forward((ServletRequest)request, (ServletResponse)response);
                return null;
            }
            if (!this.validateMaxInstances(spec)) {
                throw new ContainerProxyException("Cannot start new proxy because the maximum amount of instances of this proxy has been reached");
            }
            List runtimeValues = this.shinyProxySpecProvider.getRuntimeValues(spec);
            String id = UUID.randomUUID().toString();
            runtimeValues.add(new RuntimeValue((RuntimeValueKey)PublicPathKey.inst, (Object)this.getPublicPath(appRequestInfo)));
            runtimeValues.add(new RuntimeValue((RuntimeValueKey)AppInstanceKey.inst, (Object)appRequestInfo.getAppInstance()));
            try {
                this.proxyService.startProxy(this.userService.getCurrentAuth(), spec, runtimeValues, id, null).run();
            }
            catch (Throwable t) {
                throw new ContainerProxyException("Failed to start app " + appRequestInfo.getAppName(), t);
            }
            proxy = this.proxyService.getUserProxy(id);
        }
        if (proxy.getStatus() == ProxyStatus.Up) {
            return proxy;
        }
        if (proxy.getStatus() == ProxyStatus.New) {
            for (int i = 0; i < 600; ++i) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ex) {
                    throw new ContainerProxyException("Failed to start app " + appRequestInfo.getAppName());
                }
                Proxy result = this.proxyService.getProxy(proxy.getId());
                if (result == null) {
                    throw new ContainerProxyException("Failed to start app " + appRequestInfo.getAppName());
                }
                if (result.getStatus().equals((Object)ProxyStatus.Up)) {
                    return result;
                }
                if (result.getStatus().equals((Object)ProxyStatus.New)) continue;
                throw new ContainerProxyException("Failed to start app " + appRequestInfo.getAppName());
            }
        }
        throw new ContainerProxyException("Failed to start app " + appRequestInfo.getAppName());
    }

    private String getPublicPath(AppRequestInfo appRequestInfo) {
        return this.contextPathHelper.withEndingSlash() + "app_direct_i/" + appRequestInfo.getAppName() + "/" + appRequestInfo.getAppInstance();
    }
}

