/*
 * Decompiled with CFR 0.152.
 */
package eu.openanalytics.shinyproxy.controllers;

import eu.openanalytics.containerproxy.model.spec.ProxySpec;
import eu.openanalytics.shinyproxy.ShinyProxySpecProvider;
import eu.openanalytics.shinyproxy.controllers.BaseController;
import eu.openanalytics.shinyproxy.controllers.IndexController;
import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class IndexController
extends BaseController {
    private static final String PROXY_LANDING_PAGE_SINGLE_APP_OPTION = "SingleApp";
    private static final String PROXY_LANDING_PAGE_FIRST_APP_OPTION = "FirstApp";
    private static final String PROXY_LANDING_PAGE_INDEX_OPTION = "/";
    @Inject
    private ShinyProxySpecProvider shinyProxySpecProvider;
    @Inject
    private Environment environment;
    private MyAppsMode myAppsMode;
    private String landingPage;

    @PostConstruct
    public void init() {
        this.myAppsMode = (MyAppsMode)this.environment.getProperty("proxy.my-apps-mode", MyAppsMode.class, (Object)MyAppsMode.None);
        this.landingPage = this.environment.getProperty("proxy.landing-page", PROXY_LANDING_PAGE_INDEX_OPTION);
    }

    @RequestMapping(path={"", "/"})
    private Object index(ModelMap map, HttpServletRequest request) {
        if (!(this.landingPage.equals(PROXY_LANDING_PAGE_INDEX_OPTION) || this.landingPage.equals(PROXY_LANDING_PAGE_SINGLE_APP_OPTION) || this.landingPage.equals(PROXY_LANDING_PAGE_FIRST_APP_OPTION))) {
            return new RedirectView(this.landingPage, true);
        }
        if (request.getServletPath().equals("")) {
            return new RedirectView(PROXY_LANDING_PAGE_INDEX_OPTION, true);
        }
        List apps = this.proxyService.getUserSpecs();
        if (!apps.isEmpty() && this.landingPage.equals(PROXY_LANDING_PAGE_FIRST_APP_OPTION)) {
            return new RedirectView("/app/" + ((ProxySpec)apps.getFirst()).getId(), true);
        }
        if (apps.size() == 1 && this.landingPage.equals(PROXY_LANDING_PAGE_SINGLE_APP_OPTION)) {
            return new RedirectView("/app/" + ((ProxySpec)apps.getFirst()).getId(), true);
        }
        this.prepareMap(map, request);
        map.put((Object)"page", (Object)"index");
        map.put((Object)"myAppsMode", (Object)this.myAppsMode.toString());
        return "index";
    }
}

