/*
 * Decompiled with CFR 0.152.
 */
package eu.openanalytics.shinyproxy.controllers;

import eu.openanalytics.containerproxy.api.dto.ApiResponse;
import eu.openanalytics.containerproxy.log.LogPaths;
import eu.openanalytics.containerproxy.model.runtime.Proxy;
import eu.openanalytics.containerproxy.model.runtime.runtimevalues.RuntimeValueKey;
import eu.openanalytics.containerproxy.model.spec.ProxySpec;
import eu.openanalytics.containerproxy.service.LogService;
import eu.openanalytics.containerproxy.service.StructuredLogger;
import eu.openanalytics.containerproxy.spec.IProxySpecProvider;
import eu.openanalytics.shinyproxy.ShinyProxySpecExtension;
import eu.openanalytics.shinyproxy.controllers.BaseController;
import eu.openanalytics.shinyproxy.controllers.dto.ReportIssueDto;
import eu.openanalytics.shinyproxy.runtimevalues.AppInstanceKey;
import jakarta.mail.internet.MimeMessage;
import java.io.File;
import javax.inject.Inject;
import net.logstash.logback.argument.StructuredArguments;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.http.ResponseEntity;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class IssueController
extends BaseController {
    private final String mailFromAddress;
    private final String defaultMailSubject;
    @Inject
    private LogService logService;
    @Inject
    private IProxySpecProvider proxySpecProvider;
    @Autowired(required=false)
    private JavaMailSender mailSender;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final StructuredLogger slogger = new StructuredLogger(this.logger);

    public IssueController(Environment environment) {
        this.mailFromAddress = environment.getProperty("proxy.support.mail-from-address", "issues@shinyproxy.io");
        this.defaultMailSubject = environment.getProperty("proxy.support.mail-subject", "ShinyProxy Error Report");
    }

    @RequestMapping(value={"/issue"}, method={RequestMethod.POST})
    public ResponseEntity<ApiResponse<Void>> postIssue(@RequestBody ReportIssueDto reportIssueDto) {
        if (StringUtils.isBlank((CharSequence)this.defaultSupportAddress) || this.mailSender == null) {
            return ApiResponse.fail((Object)"Report issue is not configured");
        }
        if (StringUtils.isBlank((CharSequence)reportIssueDto.getMessage())) {
            return ApiResponse.fail((Object)"Cannot report issue: no message provided");
        }
        if (StringUtils.isBlank((CharSequence)reportIssueDto.getCurrentLocation())) {
            return ApiResponse.fail((Object)"Cannot report issue: no currentLocation provided");
        }
        Proxy proxy = null;
        String supportAddress = this.defaultSupportAddress;
        String subject = this.defaultMailSubject;
        if (!StringUtils.isBlank((CharSequence)reportIssueDto.getProxyId())) {
            proxy = this.proxyService.getUserProxy(reportIssueDto.getProxyId());
            if (proxy == null) {
                return ApiResponse.failForbidden();
            }
            ProxySpec proxySpec = this.proxySpecProvider.getSpec(proxy.getSpecId());
            if (proxySpec != null) {
                ShinyProxySpecExtension extension = (ShinyProxySpecExtension)proxySpec.getSpecExtension(ShinyProxySpecExtension.class);
                if (extension.getSupportMailToAddress() != null) {
                    supportAddress = extension.getSupportMailToAddress();
                }
                if (extension.getSupportMailSubject() != null) {
                    subject = extension.getSupportMailSubject();
                }
            }
        }
        if (this.sendSupportMail(proxy, supportAddress, subject, reportIssueDto.getMessage(), reportIssueDto.getCurrentLocation())) {
            return ApiResponse.success();
        }
        return ApiResponse.fail((Object)"Error while sending e-mail");
    }

    private boolean sendSupportMail(Proxy proxy, String supportAddress, String subject, String message, String currentLocation) {
        try {
            MimeMessage mailMessage = this.mailSender.createMimeMessage();
            MimeMessageHelper helper = new MimeMessageHelper(mailMessage, true);
            helper.setFrom(this.mailFromAddress);
            helper.addTo(supportAddress);
            helper.setSubject(subject);
            String lineSep = System.lineSeparator();
            StringBuilder body = new StringBuilder();
            body.append(String.format("This is an error report generated by ShinyProxy%s", lineSep));
            body.append(String.format("User: %s%s", this.userService.getCurrentUserId(), lineSep));
            body.append(String.format("Location: %s%s", currentLocation, lineSep));
            body.append(String.format("Message: %s%s", message, lineSep));
            if (proxy != null) {
                body.append(String.format("AppId: %s%s", proxy.getId(), lineSep));
                body.append(String.format("App: %s%s", proxy.getSpecId(), lineSep));
                String instanceName = proxy.getRuntimeValue((RuntimeValueKey)AppInstanceKey.inst);
                if (instanceName.equals("_")) {
                    body.append(String.format("Instance name: Default%s", lineSep));
                } else {
                    body.append(String.format("Instance name: %s%s", instanceName, lineSep));
                }
                LogPaths filePaths = this.logService.getLogs(proxy);
                if (filePaths != null) {
                    File stdout = filePaths.getStdout().toFile();
                    if (stdout.exists() && stdout.length() > 0L) {
                        helper.addAttachment(stdout.getName(), stdout);
                        File stderr = filePaths.getStderr().toFile();
                        if (stderr.exists() && stderr.length() > 0L) {
                            helper.addAttachment(stderr.getName(), stderr);
                        }
                    } else {
                        body.append(String.format("Log (stdout): %s%s", filePaths.getStdout(), lineSep));
                        body.append(String.format("Log (stderr): %s%s", filePaths.getStderr(), lineSep));
                    }
                }
            }
            helper.setText(body.toString());
            this.mailSender.send(mailMessage);
            if (proxy != null) {
                this.slogger.info(proxy, "User reported an issue, location: " + currentLocation);
            } else {
                this.logger.info("[{}] User reported an issue, location: " + currentLocation, (Object)StructuredArguments.kv((String)"user", (Object)this.userService.getCurrentUserId()));
            }
            return true;
        }
        catch (Exception e) {
            this.logger.error("Error while sending issue report", (Throwable)e);
            return false;
        }
    }
}

