/*
 * Decompiled with CFR 0.152.
 */
package eu.openanalytics.shinyproxy.monitoring;

import eu.openanalytics.containerproxy.service.UserService;
import eu.openanalytics.containerproxy.util.ProxyMappingManager;
import eu.openanalytics.shinyproxy.monitoring.MonitoringService;
import io.undertow.server.HttpServerExchange;
import io.undertow.servlet.handlers.ServletRequestContext;
import io.undertow.util.HttpString;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.util.UrlPathHelper;

@Controller
public class MonitoringController {
    private final ProxyMappingManager proxyMappingManager;
    private final UserService userService;
    private final MonitoringService monitoringService;
    private final UrlPathHelper urlPathHelper = new UrlPathHelper();

    public MonitoringController(ProxyMappingManager proxyMappingManager, UserService userService, MonitoringService monitoringService) {
        this.proxyMappingManager = proxyMappingManager;
        this.userService = userService;
        this.monitoringService = monitoringService;
    }

    @RequestMapping(value={"/grafana/**"})
    public void grafana(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (!this.monitoringService.isEnabled()) {
            request.setAttribute("jakarta.servlet.error.status_code", (Object)HttpStatus.FORBIDDEN.value());
            request.getRequestDispatcher("/error").forward((ServletRequest)request, (ServletResponse)response);
            return;
        }
        String uri = this.urlPathHelper.getPathWithinApplication(request);
        if (uri.equals("/grafana")) {
            response.sendRedirect("/grafana/");
            return;
        }
        if (!uri.startsWith("/grafana/")) {
            throw new IllegalStateException("TODO");
        }
        String target = uri.replace("/grafana/", "/grafana_internal/");
        HttpServerExchange exchange = ServletRequestContext.current().getExchange();
        exchange.putAttachment(ProxyMappingManager.ATTACHMENT_KEY_DISPATCHER, (Object)this.proxyMappingManager);
        exchange.getRequestHeaders().put(new HttpString("X-SP-UserId"), this.userService.getCurrentUserId());
        request.startAsync();
        request.getRequestDispatcher(target).forward((ServletRequest)request, (ServletResponse)response);
    }
}

